/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import mezz.jei.common.gui.GuiEventHandler;
import mezz.jei.common.input.ClientInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.startup.JeiEventHandlers;
import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class EventRegistration {
    @Nullable
    private ClientInputHandler clientInputHandler;
    @Nullable
    private GuiEventHandler guiEventHandler;
    private boolean registered;

    public void setEventHandlers(JeiEventHandlers eventHandlers) {
        this.clientInputHandler = eventHandlers.clientInputHandler();
        this.guiEventHandler = eventHandlers.guiEventHandler();
        if (!this.registered) {
            this.registerEvents();
            this.registered = true;
        }
    }

    private void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (this.guiEventHandler != null) {
                this.guiEventHandler.onGuiInit(screen);
                ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((screen1, key, scancode, modifiers) -> {
                    if (this.clientInputHandler != null) {
                        UserInput userInput = UserInput.fromVanilla(key, scancode, modifiers, InputType.IMMEDIATE);
                        return !this.clientInputHandler.onKeyboardKeyPressedPre(screen1, userInput);
                    }
                    return true;
                });
                ScreenMouseEvents.allowMouseClick((class_437)screen).register((screen1, mouseX, mouseY, button) -> {
                    if (this.clientInputHandler == null) {
                        return true;
                    }
                    return UserInput.fromVanilla(mouseX, mouseY, button, InputType.IMMEDIATE).map(input -> !this.clientInputHandler.onGuiMouseClicked(screen1, (UserInput)input)).orElse(true);
                });
                ScreenMouseEvents.allowMouseScroll((class_437)screen).register((screen1, mouseX, mouseY, horizontalAmount, verticalAmount) -> {
                    if (this.clientInputHandler == null) {
                        return false;
                    }
                    return !this.clientInputHandler.onGuiMouseScroll(mouseX, mouseY, verticalAmount);
                });
                ScreenEvents.afterRender((class_437)screen).register((screen1, poseStack, mouseX, mouseY, tickDelta) -> {
                    if (this.guiEventHandler != null) {
                        this.guiEventHandler.onDrawScreenPost(screen1, poseStack, mouseX, mouseY);
                    }
                });
            }
        });
        JeiCharTypedEvents.BEFORE_CHAR_TYPED.register((guiEventListener, codepoint, modifiers) -> {
            if (this.clientInputHandler != null && guiEventListener instanceof class_437) {
                class_437 screen = (class_437)guiEventListener;
                return this.clientInputHandler.onKeyboardCharTypedPre(screen, codepoint, modifiers);
            }
            return false;
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (this.guiEventHandler != null) {
                this.guiEventHandler.onGuiOpen(screen);
            }
        });
        JeiScreenEvents.AFTER_RENDER_BACKGROUND.register((screen, poseStack) -> {
            if (this.guiEventHandler != null) {
                this.guiEventHandler.onDrawBackgroundPost(screen, poseStack);
            }
        });
        JeiScreenEvents.DRAW_FOREGROUND.register((screen, poseStack, mouseX, mouseY) -> {
            if (this.guiEventHandler != null) {
                this.guiEventHandler.onDrawForeground(screen, poseStack, mouseX, mouseY);
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (this.guiEventHandler != null) {
                this.guiEventHandler.onClientTick();
            }
        });
    }

    public void clear() {
        this.clientInputHandler = null;
        this.guiEventHandler = null;
    }
}

